/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.command;

import com.andavin.images.command.BaseCommand;
import com.andavin.util.Logger;
import com.andavin.util.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

final class CommandExecutor
extends Command {
    private final BaseCommand command;

    CommandExecutor(BaseCommand command) {
        super(command.getName(), command.getDescription(), command.getUsage(), Arrays.asList(command.getAliases()));
        this.command = command;
    }

    public boolean execute(CommandSender sender, String label, String[] args) {
        try {
            BaseCommand cmd = this.getExecutable(this.command, args);
            if (cmd != this.command) {
                args = this.trimArgs(cmd, args);
            }
            if (!cmd.hasPermission(sender, args)) {
                sender.sendMessage("\u00a7cInsufficient permission.");
                return true;
            }
            if (args.length < cmd.getMinimumArgs()) {
                sender.sendMessage(" \u00a7c\u00a7m----------------------------------------------------");
                sender.sendMessage(StringUtil.centerMessage("\u00a7cNot enough arguments!"));
                sender.sendMessage(StringUtil.centerMessage("\u00a77Try \u00a7c" + cmd.getUsage()));
                sender.sendMessage(StringUtil.centerMessage("\u00a7e" + cmd.getDescription()));
                sender.sendMessage(" \u00a7c\u00a7m----------------------------------------------------");
                return true;
            }
            if (sender instanceof Player) {
                cmd.execute((Player)sender, label, args);
            } else {
                cmd.execute(sender, label, args);
            }
        }
        catch (Throwable e) {
            Logger.handle(e, arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
        }
        return true;
    }

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        if (args.length == 0) {
            return Collections.emptyList();
        }
        String last = args[args.length - 1].toLowerCase();
        BaseCommand cmd = this.getExecutable(this.command, args);
        Map<String, BaseCommand> children = cmd.getChildren();
        LinkedList<String> completions = new LinkedList<String>();
        children.forEach((name, command) -> {
            if (name.startsWith(last) && !completions.contains(command.getName())) {
                completions.add(command.getName());
            }
        });
        args = this.trimArgs(cmd, args);
        if (args.length > 0) {
            cmd.tabComplete(sender, args, completions);
        }
        return completions;
    }

    private BaseCommand getExecutable(BaseCommand cmd, String[] args) {
        String arg;
        BaseCommand child;
        String[] stringArray = args;
        int n = stringArray.length;
        for (int i = 0; i < n && (child = this.getChild(cmd, arg = stringArray[i])) != null; ++i) {
            cmd = child;
        }
        return cmd;
    }

    private BaseCommand getChild(BaseCommand cmd, String arg) {
        return cmd.getChildren().get(arg.toLowerCase());
    }

    private String[] trimArgs(BaseCommand child, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase(child.getName())) {
                return (String[])ArrayUtils.subarray((Object[])args, (int)(i + 1), (int)args.length);
            }
            for (String alias : child.getAliases()) {
                if (!args[i].equalsIgnoreCase(alias)) continue;
                return (String[])ArrayUtils.subarray((Object[])args, (int)(i + 1), (int)args.length);
            }
        }
        return args;
    }
}

